/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.xml.ser;

import com.fasterxml.jackson.xml.ser.ToXmlGenerator;
import com.fasterxml.jackson.xml.util.XmlInfo;
import java.io.IOException;
import javax.xml.namespace.QName;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.annotate.JsonTypeInfo;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.TypeSerializer;
import org.codehaus.jackson.map.ser.BeanPropertyWriter;
import org.codehaus.jackson.map.ser.BeanSerializer;

public class XmlBeanSerializer
extends BeanSerializer {
    public static final String KEY_XML_INFO = new String("xmlInfo");
    protected final int _attributeCount;
    protected final QName[] _xmlNames;

    public XmlBeanSerializer(BeanSerializer src) {
        super(src);
        this._xmlNames = new QName[this._props.length];
        for (BeanPropertyWriter bpw : this._props) {
            XmlInfo info = (XmlInfo)bpw.getInternalSetting((Object)KEY_XML_INFO);
            String ns = null;
            if (info != null) {
                ns = info.getNamespace();
            }
            this._xmlNames[i] = new QName(ns == null ? "" : ns, bpw.getName());
        }
        int attrCount = 0;
        for (BeanPropertyWriter bpw : this._props) {
            if (!XmlBeanSerializer._isAttribute(bpw)) continue;
            attrCount = XmlBeanSerializer._orderAttributesFirst(this._props, this._filteredProps);
            break;
        }
        this._attributeCount = attrCount;
    }

    protected XmlBeanSerializer(XmlBeanSerializer src, BeanPropertyWriter[] filtered) {
        super(src._handledType, src._props, filtered, src._anyGetterWriter, src._propertyFilterId);
        this._attributeCount = src._attributeCount;
        this._xmlNames = src._xmlNames;
    }

    protected void serializeFields(Object bean, JsonGenerator jgen0, SerializerProvider provider) throws IOException, JsonGenerationException {
        int i;
        ToXmlGenerator jgen = (ToXmlGenerator)jgen0;
        BeanPropertyWriter[] props = this._filteredProps != null && provider.getSerializationView() != null ? this._filteredProps : this._props;
        int attrCount = this._attributeCount;
        if (attrCount > 0) {
            jgen.setNextIsAttribute(true);
        }
        QName[] xmlNames = this._xmlNames;
        try {
            int len = props.length;
            for (i = 0; i < len; ++i) {
                if (i == attrCount) {
                    jgen.setNextIsAttribute(false);
                }
                jgen.setNextName(xmlNames[i]);
                BeanPropertyWriter prop = props[i];
                if (prop == null) continue;
                prop.serializeAsField(bean, (JsonGenerator)jgen, provider);
            }
            if (this._anyGetterWriter != null) {
                this._anyGetterWriter.getAndSerialize(bean, (JsonGenerator)jgen, provider);
            }
        }
        catch (Exception e) {
            String name = i == props.length ? "[anySetter]" : props[i].getName();
            this.wrapAndThrow(provider, e, bean, name);
        }
        catch (StackOverflowError e) {
            JsonMappingException mapE = new JsonMappingException("Infinite recursion (StackOverflowError)");
            String name = i == props.length ? "[anySetter]" : props[i].getName();
            mapE.prependPath(new JsonMappingException.Reference(bean, name));
            throw mapE;
        }
    }

    public void serializeWithType(Object bean, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonGenerationException {
        if (typeSer.getTypeInclusion() == JsonTypeInfo.As.PROPERTY) {
            ToXmlGenerator xgen = (ToXmlGenerator)jgen;
            xgen.setNextIsAttribute(true);
            super.serializeWithType(bean, jgen, provider, typeSer);
            if (this._attributeCount == 0) {
                xgen.setNextIsAttribute(false);
            }
        } else {
            super.serializeWithType(bean, jgen, provider, typeSer);
        }
    }

    protected static boolean _isAttribute(BeanPropertyWriter bpw) {
        XmlInfo info = (XmlInfo)bpw.getInternalSetting((Object)KEY_XML_INFO);
        return info != null && info.isAttribute();
    }

    protected static int _orderAttributesFirst(BeanPropertyWriter[] properties, BeanPropertyWriter[] filteredProperties) {
        int attrCount = 0;
        int len = properties.length;
        for (int i = 0; i < len; ++i) {
            BeanPropertyWriter bpw = properties[i];
            if (!XmlBeanSerializer._isAttribute(bpw)) continue;
            if (attrCount < i) {
                properties[i] = properties[attrCount];
                properties[attrCount] = bpw;
                if (filteredProperties != null) {
                    BeanPropertyWriter fbpw = filteredProperties[i];
                    filteredProperties[i] = filteredProperties[attrCount];
                    filteredProperties[attrCount] = fbpw;
                }
            }
            ++attrCount;
        }
        return attrCount;
    }
}

