/*
 * Decompiled with CFR 0.152.
 */
package samples;

import com.amazon.paapi5.v1.ApiClient;
import com.amazon.paapi5.v1.ApiException;
import com.amazon.paapi5.v1.ApiResponse;
import com.amazon.paapi5.v1.BrowseNode;
import com.amazon.paapi5.v1.ErrorData;
import com.amazon.paapi5.v1.GetBrowseNodesRequest;
import com.amazon.paapi5.v1.GetBrowseNodesResource;
import com.amazon.paapi5.v1.GetBrowseNodesResponse;
import com.amazon.paapi5.v1.PartnerType;
import com.amazon.paapi5.v1.api.DefaultApi;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SampleGetBrowseNodesApiWithHttpInfo {
    private static Map<String, BrowseNode> parse_response(List<BrowseNode> browseNodes) {
        HashMap<String, BrowseNode> mappedResponse = new HashMap<String, BrowseNode>();
        for (BrowseNode browseNode : browseNodes) {
            mappedResponse.put(browseNode.getId(), browseNode);
        }
        return mappedResponse;
    }

    public static void main(String[] args) {
        ApiClient client = new ApiClient();
        client.setAccessKey("<YOUR-ACCESS-KEY-HERE>");
        client.setSecretKey("<YOUR-SECRET-KEY-HERE>");
        String partnerTag = "<YOUR-PARTNER-TAG-HERE>";
        client.setHost("webservices.amazon.com");
        client.setRegion("us-east-1");
        DefaultApi api = new DefaultApi(client);
        ArrayList<GetBrowseNodesResource> getBrowseNodesResources = new ArrayList<GetBrowseNodesResource>();
        getBrowseNodesResources.add(GetBrowseNodesResource.ANCESTOR);
        getBrowseNodesResources.add(GetBrowseNodesResource.CHILDREN);
        ArrayList<String> browseNodeIds = new ArrayList<String>();
        browseNodeIds.add("3040");
        browseNodeIds.add("0");
        browseNodeIds.add("3045");
        GetBrowseNodesRequest getBrowseNodesRequest = new GetBrowseNodesRequest().browseNodeIds(browseNodeIds).partnerTag(partnerTag).resources(getBrowseNodesResources).partnerType(PartnerType.ASSOCIATES);
        try {
            ApiResponse<GetBrowseNodesResponse> response = api.getBrowseNodesWithHttpInfo(getBrowseNodesRequest);
            System.out.println("API called successfully");
            System.out.println("Complete response (data): " + response.getData());
            System.out.println("HTTP Info: " + response.getHeaders());
            if (response.getData() != null && response.getData().getBrowseNodesResult() != null && response.getData().getBrowseNodesResult().getBrowseNodes() != null) {
                System.out.println("Printing all brose node information in BrowseNodesResults:");
                Map<String, BrowseNode> responseList = SampleGetBrowseNodesApiWithHttpInfo.parse_response(response.getData().getBrowseNodesResult().getBrowseNodes());
                for (String browseNodeId : browseNodeIds) {
                    System.out.println("Printing information about the browse node with Id: " + browseNodeId);
                    if (responseList.get(browseNodeId) != null) {
                        BrowseNode browseNode = responseList.get(browseNodeId);
                        if (browseNode.getId() != null) {
                            System.out.println("BrowseNodeID: " + browseNode.getId());
                        }
                        if (browseNode.getDisplayName() != null) {
                            System.out.println("DisplayName: " + browseNode.getDisplayName());
                        }
                        if (browseNode.getContextFreeName() == null) continue;
                        System.out.println("ContextFreeName: " + browseNode.getContextFreeName());
                        continue;
                    }
                    System.out.println("BrowseNode not found, check errors");
                }
            }
            if (response.getData() != null && response.getData().getErrors() != null) {
                System.out.println("Printing Errors:\nPrinting Errors from list of Errors");
                for (ErrorData error : response.getData().getErrors()) {
                    System.out.println("Error code: " + error.getCode());
                    System.out.println("Error message: " + error.getMessage());
                }
            }
        }
        catch (ApiException exception) {
            System.out.println("Error calling PA-API 5.0!");
            System.out.println("Status code: " + exception.getCode());
            System.out.println("Errors: " + exception.getResponseBody());
            System.out.println("Message: " + exception.getMessage());
            if (exception.getResponseHeaders() != null) {
                System.out.println("Request ID: " + exception.getResponseHeaders().get("x-amzn-RequestId"));
            }
        }
        catch (Exception exception) {
            System.out.println("Exception message: " + exception.getMessage());
        }
    }
}

