/*
 * Decompiled with CFR 0.152.
 */
package samples;

import com.amazon.paapi5.v1.ApiClient;
import com.amazon.paapi5.v1.ApiException;
import com.amazon.paapi5.v1.ErrorData;
import com.amazon.paapi5.v1.GetItemsRequest;
import com.amazon.paapi5.v1.GetItemsResource;
import com.amazon.paapi5.v1.GetItemsResponse;
import com.amazon.paapi5.v1.Item;
import com.amazon.paapi5.v1.PartnerType;
import com.amazon.paapi5.v1.api.DefaultApi;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SampleGetItemsApi {
    private static Map<String, Item> parse_response(List<Item> items) {
        HashMap<String, Item> mappedResponse = new HashMap<String, Item>();
        for (Item item : items) {
            mappedResponse.put(item.getASIN(), item);
        }
        return mappedResponse;
    }

    public static void main(String[] args) {
        ApiClient client = new ApiClient();
        client.setAccessKey("<YOUR-ACCESS-KEY-HERE>");
        client.setSecretKey("<YOUR-SECRET-KEY-HERE>");
        String partnerTag = "<YOUR-PARTNER-TAG-HERE>";
        client.setHost("webservices.amazon.com");
        client.setRegion("us-east-1");
        DefaultApi api = new DefaultApi(client);
        ArrayList<GetItemsResource> getItemsResources = new ArrayList<GetItemsResource>();
        getItemsResources.add(GetItemsResource.ITEMINFO_TITLE);
        getItemsResources.add(GetItemsResource.OFFERS_LISTINGS_PRICE);
        ArrayList<String> itemIds = new ArrayList<String>();
        itemIds.add("059035342X");
        itemIds.add("B0BFC7WQ6R");
        itemIds.add("1401263119");
        GetItemsRequest getItemsRequest = new GetItemsRequest().itemIds(itemIds).partnerTag(partnerTag).resources(getItemsResources).partnerType(PartnerType.ASSOCIATES);
        try {
            GetItemsResponse response = api.getItems(getItemsRequest);
            System.out.println("API called successfully");
            System.out.println("Complete response: " + response);
            if (response.getItemsResult() != null) {
                System.out.println("Printing all item information in ItemsResult:");
                Map<String, Item> responseList = SampleGetItemsApi.parse_response(response.getItemsResult().getItems());
                for (String itemId : itemIds) {
                    if (response.getItemsResult().getItems() == null) continue;
                    System.out.println("Printing information about the ASIN: " + itemId);
                    if (responseList.get(itemId) != null) {
                        Item item = responseList.get(itemId);
                        if (item.getASIN() != null) {
                            System.out.println("ASIN: " + item.getASIN());
                        }
                        if (item.getDetailPageURL() != null) {
                            System.out.println("DetailPageURL: " + item.getDetailPageURL());
                        }
                        if (item.getItemInfo() != null && item.getItemInfo().getTitle() != null && item.getItemInfo().getTitle().getDisplayValue() != null) {
                            System.out.println("Title: " + item.getItemInfo().getTitle().getDisplayValue());
                        }
                        if (item.getOffers() == null || item.getOffers().getListings() == null || item.getOffers().getListings().get(0).getPrice() == null || item.getOffers().getListings().get(0).getPrice().getDisplayAmount() == null) continue;
                        System.out.println("Buying price: " + item.getOffers().getListings().get(0).getPrice().getDisplayAmount());
                        continue;
                    }
                    System.out.println("Item not found, check errors");
                }
            }
            if (response.getErrors() != null) {
                System.out.println("Printing errors:\nPrinting Errors from list of Errors");
                for (ErrorData error : response.getErrors()) {
                    System.out.println("Error code: " + error.getCode());
                    System.out.println("Error message: " + error.getMessage());
                }
            }
        }
        catch (ApiException exception) {
            System.out.println("Error calling PA-API 5.0!");
            System.out.println("Status code: " + exception.getCode());
            System.out.println("Errors: " + exception.getResponseBody());
            System.out.println("Message: " + exception.getMessage());
            if (exception.getResponseHeaders() != null) {
                System.out.println("Request ID: " + exception.getResponseHeaders().get("x-amzn-RequestId"));
            }
        }
        catch (Exception exception) {
            System.out.println("Exception message: " + exception.getMessage());
        }
    }
}

