/*
 * Decompiled with CFR 0.152.
 */
package samples;

import com.amazon.paapi5.v1.ApiClient;
import com.amazon.paapi5.v1.ApiException;
import com.amazon.paapi5.v1.GetItemsRequest;
import com.amazon.paapi5.v1.GetItemsResource;
import com.amazon.paapi5.v1.PartnerType;
import com.amazon.paapi5.v1.api.DefaultApi;
import com.squareup.okhttp.Call;
import java.util.ArrayList;
import samples.Callback;

public class SampleGetItemsApiAsync {
    public static void main(String[] args) {
        ApiClient client = new ApiClient();
        client.setAccessKey("<YOUR-ACCESS-KEY-HERE>");
        client.setSecretKey("<YOUR-SECRET-KEY-HERE>");
        String partnerTag = "<YOUR-PARTNER-TAG-HERE>";
        client.setHost("webservices.amazon.com");
        client.setRegion("us-east-1");
        DefaultApi api = new DefaultApi(client);
        ArrayList<GetItemsResource> getItemsResources = new ArrayList<GetItemsResource>();
        getItemsResources.add(GetItemsResource.ITEMINFO_TITLE);
        getItemsResources.add(GetItemsResource.OFFERS_LISTINGS_PRICE);
        ArrayList<String> itemIds = new ArrayList<String>();
        itemIds.add("059035342X");
        itemIds.add("B00X4WHP55");
        itemIds.add("1401263119");
        GetItemsRequest getItemsRequest = new GetItemsRequest().itemIds(itemIds).partnerTag(partnerTag).resources(getItemsResources).partnerType(PartnerType.ASSOCIATES);
        try {
            Call call = api.getItemsAsync(getItemsRequest, Callback.callback_getItems);
        }
        catch (ApiException exception) {
            System.out.println("Error calling PA-API 5.0!");
            System.out.println("Status code: " + exception.getCode());
            System.out.println("Errors: " + exception.getResponseBody());
            System.out.println("Message: " + exception.getMessage());
            if (exception.getResponseHeaders() != null) {
                System.out.println("Request ID: " + exception.getResponseHeaders().get("x-amzn-RequestId"));
            }
        }
        catch (Exception exception) {
            System.out.println("Exception message: " + exception.getMessage());
        }
    }
}

